/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.kobolds.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.mcreator.kobolds.AbstractKoboldEntity;
import net.mcreator.kobolds.KoboldCrossbowAttackGoal;
import net.mcreator.kobolds.KoboldsModElements;
import net.mcreator.kobolds.itemgroup.KoboldCreativeTabItemGroup;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TridentItem;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;

@KoboldsModElements.ModElement.Tag
public class KoboldEngineerEntity
extends KoboldsModElements.ModElement {
    public static EntityType entity = null;

    public KoboldEngineerEntity(KoboldsModElements instance) {
        super(instance, 11);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220321_a(0.6f, 1.48f).func_206830_a("kobold_engineer").setRegistryName("kobold_engineer");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -10066330, -65536, new Item.Properties().func_200916_a(KoboldCreativeTabItemGroup.tab)).setRegistryName("kobold_engineer_spawn_egg"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.25);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 18.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 0.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 1.0);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class ModelKobold
    extends SegmentedModel<CustomEntity>
    implements IHasArm {
        public ModelRenderer head;
        public ModelRenderer leftHorn;
        public ModelRenderer rightHorn;
        public ModelRenderer body;
        public ModelRenderer tail;
        public ModelRenderer rightArm;
        public ModelRenderer leftArm;
        public ModelRenderer rightLeg;
        public ModelRenderer leftLeg;
        public ModelRenderer mainHand;
        public ModelRenderer offHand;
        public ModelRenderer mainHandSit;
        public ModelRenderer offHandSit;
        private final ImmutableList<ModelRenderer> parts;

        public ModelKobold() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.rightHorn = new ModelRenderer((Model)this, 45, 0);
            this.rightHorn.func_78793_a(-2.0f, -7.0f, 2.0f);
            this.rightHorn.func_228303_a_(-1.0f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, false);
            this.setRotateAngle(this.rightHorn, -0.6109f, -0.3054f, -0.1745f);
            this.leftHorn = new ModelRenderer((Model)this, 36, 0);
            this.leftHorn.func_78793_a(2.0f, -7.0f, 2.0f);
            this.leftHorn.func_228303_a_(-1.0f, -4.0f, -1.0f, 2.0f, 5.0f, 2.0f, 0.0f, false);
            this.setRotateAngle(this.leftHorn, -0.6109f, 0.3054f, 0.1745f);
            this.rightLeg = new ModelRenderer((Model)this, 13, 31);
            this.rightLeg.func_78793_a(-1.5f, 0.0f, 0.0f);
            this.rightLeg.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.rightArm = new ModelRenderer((Model)this, 46, 16);
            this.rightArm.func_78793_a(-3.0f, -9.0f, 0.0f);
            this.rightArm.func_228303_a_(-3.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.head = new ModelRenderer((Model)this);
            this.head.func_78793_a(0.0f, -10.0f, -0.5f);
            this.head.func_78784_a(0, 0).func_228303_a_(-3.5f, -7.0f, -3.5f, 7.0f, 7.0f, 7.0f, 0.0f, false);
            this.head.func_78784_a(22, 0).func_228303_a_(-2.5f, -3.0f, -6.5f, 5.0f, 3.0f, 3.0f, 0.0f, false);
            this.head.func_78784_a(1, 3).func_228303_a_(-0.5f, -3.85f, -5.5f, 1.0f, 1.0f, 2.0f, 0.0f, false);
            this.body = new ModelRenderer((Model)this, 3, 15);
            this.body.func_78793_a(0.5f, 14.0f, 0.0f);
            this.body.func_228303_a_(-3.0f, -10.0f, -2.0f, 6.0f, 10.0f, 4.0f, 0.0f, false);
            this.tail = new ModelRenderer((Model)this, 24, 15);
            this.tail.func_78793_a(0.0f, 0.0f, 0.0f);
            this.tail.func_228303_a_(-1.0f, -3.0f, 2.0f, 2.0f, 12.0f, 2.0f, 0.0f, false);
            this.setRotateAngle(this.tail, 0.6109f, 0.0f, 0.0f);
            this.leftArm = new ModelRenderer((Model)this, 33, 16);
            this.leftArm.func_78793_a(3.0f, -9.0f, 0.0f);
            this.leftArm.func_228303_a_(0.0f, -0.85f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.leftLeg = new ModelRenderer((Model)this, 0, 31);
            this.leftLeg.func_78793_a(1.5f, 0.0f, 0.0f);
            this.leftLeg.func_228303_a_(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, 0.0f, false);
            this.mainHand = new ModelRenderer((Model)this, 0, 0);
            this.mainHand.func_78793_a(-2.8f, 7.5f, 0.0f);
            this.mainHand.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.offHand = new ModelRenderer((Model)this, 0, 0);
            this.offHand.func_78793_a(3.8f, 7.5f, 0.0f);
            this.offHand.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.mainHandSit = new ModelRenderer((Model)this, 0, 0);
            this.mainHandSit.func_78793_a(-2.8f, 11.65f, 0.0f);
            this.mainHandSit.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.offHandSit = new ModelRenderer((Model)this, 0, 0);
            this.offHandSit.func_78793_a(3.8f, 11.65f, 0.0f);
            this.offHandSit.func_228303_a_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false);
            this.head.func_78792_a(this.rightHorn);
            this.head.func_78792_a(this.leftHorn);
            this.body.func_78792_a(this.tail);
            this.body.func_78792_a(this.leftLeg);
            this.body.func_78792_a(this.rightLeg);
            this.body.func_78792_a(this.head);
            this.body.func_78792_a(this.leftArm);
            this.body.func_78792_a(this.rightArm);
            this.rightArm.func_78792_a(this.mainHand);
            this.leftArm.func_78792_a(this.offHand);
            this.rightArm.func_78792_a(this.mainHandSit);
            this.leftArm.func_78792_a(this.offHandSit);
            this.parts = ImmutableList.of((Object)this.body);
        }

        public void func_225598_a_(MatrixStack ms, IVertexBuilder vb, int i1, int i2, float f1, float f2, float f3, float f4) {
            if (this.field_217113_d) {
                ms.func_227860_a_();
                ms.func_227862_a_(0.875f, 0.875f, 0.875f);
                ms.func_227861_a_(0.0, (double)0.52f, 0.0);
                this.body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
                ms.func_227865_b_();
            } else {
                ms.func_227860_a_();
                ms.func_227862_a_(0.875f, 0.875f, 0.875f);
                ms.func_227861_a_(0.0, (double)0.22f, 0.0);
                this.body.func_228309_a_(ms, vb, i1, i2, f1, f2, f3, f4);
                ms.func_227865_b_();
            }
        }

        private void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public Iterable<ModelRenderer> func_225601_a_() {
            return this.parts;
        }

        public void setRotationAngles(CustomEntity kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
            float f3;
            float f2;
            float progress;
            this.head.field_78796_g = headYaw * ((float)Math.PI / 180);
            this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
            this.body.field_78795_f = 0.0f;
            this.body.field_78796_g = 0.0f;
            this.body.field_78808_h = 0.0f;
            this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.mainHand.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.offHand.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.field_78796_g = 0.0f;
            this.mainHand.field_78796_g = 0.0f;
            this.leftArm.field_78796_g = 0.0f;
            this.offHand.field_78796_g = 0.0f;
            this.rightArm.field_78808_h = 0.0f;
            this.mainHand.field_78808_h = 0.0f;
            this.leftArm.field_78808_h = 0.0f;
            this.offHand.field_78808_h = 0.0f;
            this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.rightLeg.field_78796_g = 0.0f;
            this.leftLeg.field_78796_g = 0.0f;
            this.rightArm.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.mainHand.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.leftArm.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            this.offHand.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
            if (kobold.func_190630_a(EquipmentSlotType.MAINHAND)) {
                if (kobold.func_213398_dR()) {
                    if (kobold.func_184638_cS()) {
                        this.leftArm.field_78795_f = -2.0944f;
                        this.offHand.field_78795_f = -2.0944f;
                        this.leftArm.field_78796_g = -0.1745f;
                        this.offHand.field_78796_g = -0.1745f;
                    } else {
                        this.rightArm.field_78795_f = -2.0944f;
                        this.mainHand.field_78795_f = -2.0944f;
                        this.rightArm.field_78796_g = 0.1745f;
                        this.mainHand.field_78796_g = 0.1745f;
                    }
                } else if (kobold.func_184614_ca().func_77973_b() instanceof CrossbowItem) {
                    if (kobold.func_184638_cS()) {
                        if (kobold.isCharging()) {
                            this.leftArm.field_78795_f = -0.6981f;
                            this.offHand.field_78795_f = -0.6981f;
                            this.leftArm.field_78796_g = 0.3491f;
                            this.offHand.field_78796_g = 0.3491f;
                            this.rightArm.field_78795_f = -1.1345f;
                            this.mainHand.field_78795_f = -1.1345f;
                            this.rightArm.field_78796_g = -0.5672f;
                            this.mainHand.field_78796_g = -0.5672f;
                        } else if (CrossbowItem.func_220012_d((ItemStack)kobold.func_184614_ca())) {
                            this.leftArm.field_78795_f = -1.4399f;
                            this.offHand.field_78795_f = -1.4399f;
                            this.leftArm.field_78796_g = 0.2618f;
                            this.offHand.field_78796_g = 0.2618f;
                            this.rightArm.field_78795_f = -1.3963f;
                            this.mainHand.field_78795_f = -1.3963f;
                            this.rightArm.field_78796_g = -0.3054f;
                            this.mainHand.field_78796_g = -0.3054f;
                        }
                    } else if (kobold.isCharging()) {
                        this.rightArm.field_78795_f = -0.6981f;
                        this.mainHand.field_78795_f = -0.6981f;
                        this.rightArm.field_78796_g = -0.3491f;
                        this.mainHand.field_78796_g = -0.3491f;
                        this.leftArm.field_78795_f = -1.1345f;
                        this.offHand.field_78795_f = -1.1345f;
                        this.leftArm.field_78796_g = 0.5672f;
                        this.offHand.field_78796_g = 0.5672f;
                    } else if (CrossbowItem.func_220012_d((ItemStack)kobold.func_184614_ca())) {
                        this.rightArm.field_78795_f = -1.4399f;
                        this.mainHand.field_78795_f = -1.4399f;
                        this.rightArm.field_78796_g = -0.2618f;
                        this.mainHand.field_78796_g = -0.2618f;
                        this.leftArm.field_78795_f = -1.3963f;
                        this.offHand.field_78795_f = -1.3963f;
                        this.leftArm.field_78796_g = 0.3054f;
                        this.offHand.field_78796_g = 0.3054f;
                    }
                }
            }
            if (kobold.func_190630_a(EquipmentSlotType.OFFHAND)) {
                if (kobold.func_184592_cb().func_77973_b() instanceof TridentItem) {
                    if (kobold.func_213398_dR()) {
                        if (kobold.func_184638_cS()) {
                            this.rightArm.field_78795_f = 2.8798f;
                            this.mainHand.field_78795_f = 2.8798f;
                            this.leftArm.field_78795_f = 0.0f;
                            this.offHand.field_78795_f = 0.0f;
                        } else {
                            this.leftArm.field_78795_f = 2.8798f;
                            this.offHand.field_78795_f = 2.8798f;
                            this.rightArm.field_78795_f = 0.0f;
                            this.mainHand.field_78795_f = 0.0f;
                        }
                    } else if (kobold.func_184638_cS()) {
                        this.rightArm.field_78796_g = 0.0f;
                        this.mainHand.field_78796_g = 0.0f;
                    } else {
                        this.leftArm.field_78796_g = 0.0f;
                        this.offHand.field_78796_g = 0.0f;
                    }
                } else if (kobold.func_184638_cS()) {
                    this.rightArm.field_78795_f = -0.8727f;
                    this.mainHand.field_78795_f = -0.8727f;
                    this.rightArm.field_78796_g = 0.0873f;
                    this.mainHand.field_78796_g = 0.0873f;
                    this.head.field_78795_f = -0.2618f;
                    this.head.field_78795_f = 0.1745f;
                } else {
                    this.leftArm.field_78795_f = -0.8727f;
                    this.offHand.field_78795_f = -0.8727f;
                    this.leftArm.field_78796_g = 0.0873f;
                    this.offHand.field_78796_g = 0.0873f;
                    this.head.field_78795_f = -0.2618f;
                    this.head.field_78795_f = 0.1745f;
                }
            }
            if (this.field_217113_d) {
                this.mainHandSit.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
                this.offHandSit.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
                this.mainHandSit.field_78796_g = 0.0f;
                this.offHandSit.field_78796_g = 0.0f;
                this.mainHandSit.field_78808_h = 0.0f;
                this.offHandSit.field_78808_h = 0.0f;
                this.mainHandSit.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
                this.offHandSit.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.04f)) * 0.04f + 0.04f;
                this.rightLeg.field_78795_f = -1.5708f;
                this.leftLeg.field_78795_f = -1.5708f;
                this.rightLeg.field_78796_g = 0.2618f;
                this.leftLeg.field_78796_g = -0.2618f;
                if (kobold.func_190630_a(EquipmentSlotType.MAINHAND)) {
                    if (kobold.func_213398_dR()) {
                        if (kobold.func_184638_cS()) {
                            this.offHandSit.field_78795_f = -2.0944f;
                            this.offHandSit.field_78796_g = -0.1745f;
                        } else {
                            this.mainHandSit.field_78795_f = -2.0944f;
                            this.mainHandSit.field_78796_g = 0.1745f;
                        }
                    } else if (kobold.func_184614_ca().func_77973_b() instanceof CrossbowItem) {
                        if (kobold.func_184638_cS()) {
                            if (kobold.isCharging()) {
                                this.offHandSit.field_78795_f = -0.6981f;
                                this.offHandSit.field_78796_g = 0.3491f;
                                this.mainHandSit.field_78795_f = -1.1345f;
                                this.mainHandSit.field_78796_g = -0.5672f;
                            } else if (CrossbowItem.func_220012_d((ItemStack)kobold.func_184614_ca())) {
                                this.offHandSit.field_78795_f = -1.4399f;
                                this.offHandSit.field_78796_g = 0.2618f;
                                this.mainHandSit.field_78795_f = -1.3963f;
                                this.mainHandSit.field_78796_g = -0.3054f;
                            }
                        } else if (kobold.isCharging()) {
                            this.mainHandSit.field_78795_f = -0.6981f;
                            this.mainHandSit.field_78796_g = -0.3491f;
                            this.offHandSit.field_78795_f = -1.1345f;
                            this.offHandSit.field_78796_g = 0.5672f;
                        } else if (CrossbowItem.func_220012_d((ItemStack)kobold.func_184614_ca())) {
                            this.mainHandSit.field_78795_f = -1.4399f;
                            this.mainHandSit.field_78796_g = -0.2618f;
                            this.offHandSit.field_78795_f = -1.3963f;
                            this.offHandSit.field_78796_g = 0.3054f;
                        }
                    }
                }
                if (kobold.func_190630_a(EquipmentSlotType.OFFHAND)) {
                    if (kobold.func_184592_cb().func_77973_b() instanceof TridentItem) {
                        if (kobold.func_213398_dR()) {
                            if (kobold.func_184638_cS()) {
                                this.mainHandSit.field_78795_f = 2.8798f;
                            } else {
                                this.offHandSit.field_78795_f = 2.8798f;
                            }
                        } else if (kobold.func_184638_cS()) {
                            this.mainHandSit.field_78796_g = 0.0f;
                        } else {
                            this.offHandSit.field_78796_g = 0.0f;
                        }
                    } else if (kobold.func_184638_cS()) {
                        this.mainHandSit.field_78795_f = -0.8727f;
                        this.mainHandSit.field_78796_g = 0.0873f;
                    } else {
                        this.offHandSit.field_78795_f = -0.8727f;
                        this.offHandSit.field_78796_g = 0.0873f;
                    }
                }
                if (this.field_217112_c > 0.0f) {
                    if (kobold.func_213398_dR()) {
                        if (kobold.func_184638_cS()) {
                            progress = this.field_217112_c;
                            progress = 1.0f - this.field_217112_c;
                            progress *= progress;
                            progress *= progress;
                            progress = 1.0f - progress;
                            f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                            this.offHandSit.field_78795_f = (float)((double)this.leftArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                        } else {
                            progress = this.field_217112_c;
                            progress = 1.0f - this.field_217112_c;
                            progress *= progress;
                            progress *= progress;
                            progress = 1.0f - progress;
                            f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                            this.mainHandSit.field_78795_f = (float)((double)this.rightArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                        }
                    } else if (kobold.func_190630_a(EquipmentSlotType.OFFHAND)) {
                        progress = this.field_217112_c;
                        this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                        this.mainHandSit.field_78796_g += this.body.field_78796_g;
                        this.offHandSit.field_78796_g += this.body.field_78796_g;
                        this.offHandSit.field_78795_f += this.body.field_78796_g;
                        progress = 1.0f - this.field_217112_c;
                        progress *= progress;
                        progress *= progress;
                        progress = 1.0f - progress;
                        f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                        f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
                        this.mainHandSit.field_78795_f = (float)((double)this.mainHandSit.field_78795_f - ((double)f2 * 1.2 + (double)f3));
                        this.mainHandSit.field_78796_g += this.body.field_78796_g * 2.0f;
                        this.mainHandSit.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
                    }
                }
            }
            if (this.field_217112_c > 0.0f) {
                if (kobold.func_213398_dR()) {
                    if (kobold.func_184638_cS()) {
                        progress = this.field_217112_c;
                        progress = 1.0f - this.field_217112_c;
                        progress *= progress;
                        progress *= progress;
                        progress = 1.0f - progress;
                        f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                        this.offHand.field_78795_f = (float)((double)this.offHand.field_78795_f - ((double)f2 / 1.2 - 1.0));
                        this.leftArm.field_78795_f = (float)((double)this.leftArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                    } else {
                        progress = this.field_217112_c;
                        progress = 1.0f - this.field_217112_c;
                        progress *= progress;
                        progress *= progress;
                        progress = 1.0f - progress;
                        f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                        this.mainHand.field_78795_f = (float)((double)this.rightArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                        this.rightArm.field_78795_f = (float)((double)this.rightArm.field_78795_f - ((double)f2 / 1.2 - 1.0));
                    }
                } else if (kobold.func_190630_a(EquipmentSlotType.OFFHAND)) {
                    progress = this.field_217112_c;
                    this.body.field_78796_g = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)progress) * ((float)Math.PI * 2))) * 0.2f;
                    this.rightArm.field_78796_g += this.body.field_78796_g;
                    this.mainHand.field_78796_g += this.body.field_78796_g;
                    this.leftArm.field_78796_g += this.body.field_78796_g;
                    this.offHand.field_78796_g += this.body.field_78796_g;
                    this.leftArm.field_78795_f += this.body.field_78796_g;
                    this.offHand.field_78795_f += this.body.field_78796_g;
                    progress = 1.0f - this.field_217112_c;
                    progress *= progress;
                    progress *= progress;
                    progress = 1.0f - progress;
                    f2 = MathHelper.func_76126_a((float)(progress * (float)Math.PI));
                    f3 = MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -(this.head.field_78795_f - 0.7f) * 0.75f;
                    this.rightArm.field_78795_f = (float)((double)this.rightArm.field_78795_f - ((double)f2 * 1.2 + (double)f3));
                    this.mainHand.field_78795_f = (float)((double)this.mainHand.field_78795_f - ((double)f2 * 1.2 + (double)f3));
                    this.rightArm.field_78796_g += this.body.field_78796_g * 2.0f;
                    this.mainHand.field_78796_g += this.body.field_78796_g * 2.0f;
                    this.rightArm.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
                    this.mainHand.field_78808_h += MathHelper.func_76126_a((float)(this.field_217112_c * (float)Math.PI)) * -0.4f;
                }
            }
        }

        public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
            switch (handSide) {
                case LEFT: {
                    if (this.field_217113_d) {
                        this.offHandSit.func_228307_a_(matrixStack);
                        matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                        matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                        break;
                    }
                    this.offHand.func_228307_a_(matrixStack);
                    matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                    break;
                }
                case RIGHT: {
                    if (this.field_217113_d) {
                        this.mainHandSit.func_228307_a_(matrixStack);
                        matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                        matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                        break;
                    }
                    this.mainHand.func_228307_a_(matrixStack);
                    matrixStack.func_227861_a_(0.0, 0.03, 0.0);
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends SegmentedModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("kobolds:textures/kobold_glow.png")));
            ((SegmentedModel)this.func_215332_c()).func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends AbstractKoboldEntity
    implements ICrossbowUser,
    IRangedAttackMob {
        private static final DataParameter<Boolean> KOBOLD_CHARGING_STATE = EntityDataManager.func_187226_a(CustomEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, new KoboldCrossbowAttackGoal<CustomEntity>(this, 1.0, 21.0f));
            this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombieEntity.class, true, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractIllagerEntity.class, true, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, VillagerEntity.class, true, false));
        }

        public void func_82196_d(LivingEntity target, float distanceFactor) {
            if (this.func_184614_ca().func_77973_b() instanceof CrossbowItem) {
                this.func_234281_b_((LivingEntity)this, 6.0f);
            }
        }

        public void func_230283_U__() {
            this.field_70708_bq = 0;
        }

        public void func_230284_a_(LivingEntity arg0, ItemStack arg1, ProjectileEntity arg2, float arg3) {
            this.func_234279_a_((LivingEntity)this, arg0, arg2, arg3, 1.6f);
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(KOBOLD_CHARGING_STATE, (Object)false);
        }

        public boolean isCharging() {
            return (Boolean)this.field_70180_af.func_187225_a(KOBOLD_CHARGING_STATE);
        }

        public void func_213671_a(boolean charging) {
            this.field_70180_af.func_187227_b(KOBOLD_CHARGING_STATE, (Object)charging);
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, (EntityModel)new ModelKobold(), 0.46f){
                {
                    super(x0, x1, x2);
                    this.func_177094_a(new GlowingLayer(this));
                    this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
                }

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("kobolds:textures/kobold_engineer.png");
                }
            });
        }
    }
}

